﻿#include "RebocapLivelinkManagerDemoWidget.h"
#include "SlateOptMacros.h"
#include "LiveLinkClient.h"
#include "Modules/ModuleManager.h"
#include "ILiveLinkClient.h"
#include "rebocap_source.h"
#include "LiveLinkSourceSettings.h"

BEGIN_SLATE_FUNCTION_BUILD_OPTIMIZATION
void SRebocapLivelinkManagerDemoWidget::Construct(const FArguments& InArgs)
{
  ChildSlot
  [
      SNew(SOverlay)
      + SOverlay::Slot()
      .HAlign(HAlign_Right)
      .VAlign(VAlign_Top)
      .Padding(FMargin(10.0f))
      [
          SNew(SBox)
          .WidthOverride(150.0f)
          .HeightOverride(50.0f)
          [
              SNew(SButton)
              .Text(this, &SRebocapLivelinkManagerDemoWidget::GetButtonText)
              .OnClicked(this, &SRebocapLivelinkManagerDemoWidget::OnButtonClicked)
          ]
      ]
  ];
}

FReply SRebocapLivelinkManagerDemoWidget::OnButtonClicked()
{
  if (bIsConnected)
  {
    DisconnectLiveLink();
  }
  else
  {
    ConnectLiveLink();
  }
  return FReply::Handled();
}

void SRebocapLivelinkManagerDemoWidget::ConnectLiveLink()
{
  // Note: It's better for you to control livelink on your own ui system
  bIsConnected = true;
  uint16_t port = 7690;  // todo change this to your own port and get port from ui input!!!
  if (!FRebocapSource::GetInstance().IsValid())
  {
    UE_LOG(LogTemp, Display, TEXT("start create rebocap live link!!!!"));
    // 创建新的 LiveLink Source
    TSharedPtr<FRebocapSource> NewSource = MakeShared<FRebocapSource>(port);

    // 获取 LiveLink Client
    IModularFeatures& ModularFeatures = IModularFeatures::Get();
    if (ModularFeatures.IsModularFeatureAvailable(ILiveLinkClient::ModularFeatureName))
    {
      ILiveLinkClient* LiveLinkClient = &ModularFeatures.GetModularFeature<ILiveLinkClient>(ILiveLinkClient::ModularFeatureName);

      if (LiveLinkClient)
      {
        // 将 Source 添加到 LiveLink Client
        FRebocapSource::SetInstance(NewSource);
        LiveLinkClient->AddSource(NewSource);
      }
    }
  } else {
    FRebocapSource::GetInstance()->ManualStart(port);
  }
}

void SRebocapLivelinkManagerDemoWidget::DisconnectLiveLink()
{
  // Note: It's better for you to control livelink on your own ui system
  bIsConnected = false;
  UE_LOG(LogTemp, Display, TEXT("DisconnectLiveLink!!!!"));
  if (FRebocapSource::GetInstance().IsValid())
  {
    UE_LOG(LogTemp, Display, TEXT("start clear rebocap live link!!!!"));
    FRebocapSource::GetInstance()->ManualStop();
  }
}

FText SRebocapLivelinkManagerDemoWidget::GetButtonText() const
{
  return bIsConnected ? FText::FromString(TEXT("Disconnect")) : FText::FromString(TEXT("Connect"));
}
END_SLATE_FUNCTION_BUILD_OPTIMIZATION
