﻿#pragma once

#include "CoreMinimal.h"
#include "Interfaces/IPluginManager.h"
#include "Modules/ModuleInterface.h"
#include "Modules/ModuleManager.h"
#include "Framework/Application/SlateApplication.h"
#include "Framework/Docking/TabManager.h"

class Frebocap_runtimeModule : public IModuleInterface
{
public:
  static inline Frebocap_runtimeModule& Get()
  {
    return FModuleManager::LoadModuleChecked<Frebocap_runtimeModule>("rebocap_runtime");
  }

  static inline bool IsAvailable()
  {
    return FModuleManager::Get().IsModuleLoaded("rebocap_runtime");
  }

  virtual void StartupModule() override
  {
    // Module startup code here
    FString BaseDir = IPluginManager::Get().FindPlugin("rebocap")->GetBaseDir();

    FString LibraryPath;
#if PLATFORM_WINDOWS
    LibraryPath = FPaths::Combine(*BaseDir, TEXT("Binaries/ThirdParty/RebocapWsSdk/Win64/rebocap_ws_sdk.dll"));
#elif PLATFORM_MAC
    LibraryPath = FPaths::Combine(*BaseDir, TEXT("Source/ThirdParty/testPulginLibrary/Mac/Release/libExampleLibrary.dylib"));
#elif PLATFORM_LINUX
    LibraryPath = FPaths::Combine(*BaseDir, TEXT("Binaries/ThirdParty/testPulginLibrary/Linux/x86_64-unknown-linux-gnu/libExampleLibrary.so"));
#endif // PLATFORM_WINDOWS

    rebocap_ws_sdk_handle_ = !LibraryPath.IsEmpty() ? FPlatformProcess::GetDllHandle(*LibraryPath) : nullptr;

#if USE_REBOCAP_LIVELINK_MANAGER_DEMO
    // 注册 Esc 键的输入处理
    FCoreDelegates::OnPostEngineInit.AddRaw(this, &Frebocap_runtimeModule::CreateUI);
#endif
    
  }

  virtual void ShutdownModule() override
  {
    // Module shutdown code here
    FPlatformProcess::FreeDllHandle(rebocap_ws_sdk_handle_);
    rebocap_ws_sdk_handle_ = nullptr;
  }

#if USE_REBOCAP_LIVELINK_MANAGER_DEMO
  void CreateUI();
#endif
  
private:
  void* rebocap_ws_sdk_handle_ = nullptr;
};

IMPLEMENT_MODULE(Frebocap_runtimeModule, rebocap_runtime)
