#pragma once

#include <string>

#include "ILiveLinkClient.h"
#include "ILiveLinkSource.h"
#include "rebocap_source_settings.h"
#include "rebocap_ws_sdk_cpp.h"

class REBOCAP_RUNTIME_API FRebocapSource final : public ILiveLinkSource, public FRunnable {
 public:
  FRebocapSource(uint16_t port);
  FRebocapSource(const FString& IPAddress, uint16_t port);

  ~FRebocapSource() final;

  // 设置LiveLinkClient
  void ReceiveClient(ILiveLinkClient *InClient, FGuid InSourceGuid) final;
  // 初始化设置
  void InitializeSettings(ULiveLinkSourceSettings *Settings) final;
  bool IsSourceStillValid() const final;
  bool RequestSourceShutdown() final;
  FText GetSourceType() const final;
  FText GetSourceMachineName() const final;
  FText GetSourceStatus() const final;
  int CalculateAndRegisterToRebocap(TArray<FVector3f> &left_vertex,
                                                TArray<FVector3f> &left_normals,
                                                TArray<FVector3f> &right_vertex,
                                                TArray<FVector3f> &right_normals,
                                                TArray<FVector3f> &skeletons,
                                                const std::string& coordinate,
                                                TArray<FVector3f> &foot_vertices) {
    if (rebocap_sdk_.IsValid()) {
      return rebocap_sdk_->CalculateAndRegisterToRebocap(left_vertex, left_normals, right_vertex, right_normals, skeletons, coordinate, foot_vertices);
    }
    return -1;
  }
  bool IsPortOpen() const {return status_;}
  void ManualStop();
  bool ManualStart(uint16_t port);

  static TSharedPtr<FRebocapSource> GetInstance();
  static void SetInstance(TSharedPtr<FRebocapSource> instance);

 private:
  ILiveLinkClient *client_;
  FGuid source_guid_;
  URebocapSourceSettings *saved_source_settings_;
  TArray<FName> subject_names_;
  uint16_t port_;
  bool status_{false};
  FRunnableThread *thread_{nullptr};
  bool running_{true};

  TSharedPtr<rebocap::RebocapWsSdk> rebocap_sdk_;
  void clear_all_subjects();
  bool open();
  uint32 Run() final;

  void pose_msg_callback(const QuatMsg* msg);

  static TSharedPtr<FRebocapSource> instance_;
};
