// Copyright Epic Games, Inc. All Rights Reserved.

using System.IO;
using UnrealBuildTool;

public class rebocap_runtime : ModuleRules
{
	public rebocap_runtime(ReadOnlyTargetRules Target) : base(Target)
	{
		
		PCHUsage = PCHUsageMode.UseExplicitOrSharedPCHs;
		
		PublicIncludePaths.Add(Path.Combine(ModuleDirectory, "Public"));
		PublicIncludePaths.Add(Path.Combine(ModuleDirectory, "Private"));
		PublicDefinitions.Add("USE_REBOCAP_LIVELINK_MANAGER_DEMO");

        PublicAdditionalLibraries.Add(Path.Combine(PluginDirectory, "x64", "Release", "rebocap_ws_sdk.lib"));

        // Delay-load the DLL, so we can load it from the right place first
        PublicDelayLoadDLLs.Add("rebocap_ws_sdk.dll");

        // Ensure that the DLL is staged along with the executable
        RuntimeDependencies.Add("$(PluginDir)/Binaries/ThirdParty/RebocapWsSdk/Win64/rebocap_ws_sdk.dll");

        PublicIncludePaths.AddRange(
			new string[] {
				// ... add public include paths required here ...
			}
			);
		
		PrivateIncludePaths.AddRange(
			new string[] {
				// ... add other private include paths required here ...
			}
			);
			
		
		PublicDependencyModuleNames.AddRange(
			new string[]
			{
				"CoreUObject", 
				"Engine",
				"Sockets", "HTTP", "Networking",
				"AnimGraphRuntime",
				"Core",
				"LiveLink",
				"InputCore",
				"LiveLinkAnimationCore",
                "LiveLinkInterface",
				// ... add other public dependencies that you statically link with here ...
			}
			);
			
		
		PrivateDependencyModuleNames.AddRange(
			new string[]
			{
				"Projects",
				"CoreUObject",
				"Engine",
				"Slate",
				"SlateCore",
				"Messaging",
				"LiveLinkInterface",
				"LiveLinkMessageBusFramework",
				// ... add private dependencies that you statically link with here ...	
			}
			);
		
		
		DynamicallyLoadedModuleNames.AddRange(
			new string[]
			{
				// ... add any modules that your module loads dynamically here ...
			}
			);
	}
}
